/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items.storage;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.ActionRegistryEntry;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.PatternIota;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.item.IotaHolderItem;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.client.gui.PatternTooltipComponent;
import at.petrak.hexcasting.common.casting.PatternRegistryManifest;
import at.petrak.hexcasting.common.entities.EntityWallScroll;
import at.petrak.hexcasting.common.misc.PatternTooltip;
import at.petrak.hexcasting.interop.inline.InlinePatternData;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5632;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;

public class ItemScroll
extends class_1792
implements IotaHolderItem {
    public static final String TAG_OP_ID = "op_id";
    public static final String TAG_PATTERN = "pattern";
    public static final String TAG_NEEDS_PURCHASE = "needs_purchase";
    public static final class_2960 ANCIENT_PREDICATE = HexAPI.modLoc("ancient");
    public final int blockSize;

    public ItemScroll(class_1792.class_1793 pProperties, int blockSize) {
        super(pProperties);
        this.blockSize = blockSize;
    }

    public static class_1799 withPerWorldPattern(class_1799 stack, String op_id) {
        class_1792 item = stack.method_7909();
        if (item instanceof ItemScroll) {
            NBTHelper.putString(stack, TAG_OP_ID, op_id);
        }
        return stack;
    }

    @Override
    @Nullable
    public class_2487 readIotaTag(class_1799 stack) {
        class_2487 pattern = NBTHelper.getCompound(stack, TAG_PATTERN);
        if (pattern == null) {
            return null;
        }
        class_2487 out = new class_2487();
        out.method_10582("hexcasting:type", "hexcasting:pattern");
        out.method_10566("hexcasting:data", (class_2520)pattern);
        return out;
    }

    @Override
    public boolean writeable(class_1799 stack) {
        return true;
    }

    @Override
    public boolean canWrite(class_1799 stack, Iota datum) {
        return datum instanceof PatternIota || datum == null;
    }

    @Override
    public void writeDatum(class_1799 stack, Iota datum) {
        if (this.canWrite(stack, datum)) {
            if (datum instanceof PatternIota) {
                PatternIota pat = (PatternIota)datum;
                NBTHelper.putCompound(stack, TAG_PATTERN, pat.getPattern().serializeToNBT());
            } else if (datum == null) {
                NBTHelper.remove(stack, TAG_PATTERN);
            }
        }
    }

    public class_1269 method_7884(class_1838 ctx) {
        class_2338 posClicked = ctx.method_8037();
        class_2350 direction = ctx.method_8038();
        class_2338 posInFront = posClicked.method_10093(direction);
        class_1657 player = ctx.method_8036();
        class_1799 itemstack = ctx.method_8041();
        if (player != null && !this.mayPlace(player, direction, itemstack, posInFront)) {
            return class_1269.field_5814;
        }
        class_1937 level = ctx.method_8045();
        class_1799 scrollStack = itemstack.method_7972();
        scrollStack.method_7939(1);
        EntityWallScroll scrollEntity = new EntityWallScroll(level, posInFront, direction, scrollStack, false, this.blockSize);
        class_2487 stackTag = itemstack.method_7969();
        if (stackTag != null) {
            class_1299.method_5881((class_1937)level, (class_1657)player, (class_1297)scrollEntity, (class_2487)stackTag);
        }
        if (scrollEntity.method_6888()) {
            if (!level.field_9236) {
                scrollEntity.method_6894();
                level.method_33596((class_1297)player, class_5712.field_28738, posClicked);
                level.method_8649((class_1297)scrollEntity);
            }
            itemstack.method_7934(1);
            return class_1269.method_29236((boolean)level.field_9236);
        }
        return class_1269.field_21466;
    }

    protected boolean mayPlace(class_1657 pPlayer, class_2350 pDirection, class_1799 pHangingEntityStack, class_2338 pPos) {
        return !pDirection.method_10166().method_10178() && pPlayer.method_7343(pPos, pDirection, pHangingEntityStack);
    }

    public class_2561 method_7864(class_1799 pStack) {
        String descID = this.method_7866(pStack);
        String ancientId = NBTHelper.getString(pStack, TAG_OP_ID);
        if (ancientId != null) {
            return class_2561.method_43469((String)(descID + ".of"), (Object[])new Object[]{class_2561.method_43471((String)("hexcasting.action." + class_2960.method_12829((String)ancientId)))});
        }
        if (NBTHelper.hasCompound(pStack, TAG_PATTERN)) {
            class_2487 compound = NBTHelper.getCompound(pStack, TAG_PATTERN);
            class_5250 patternLabel = class_2561.method_43470((String)"");
            if (compound != null) {
                HexPattern pattern = HexPattern.fromNBT(compound);
                patternLabel = class_2561.method_43470((String)": ").method_10852(new InlinePatternData(pattern).asText(false));
            }
            return class_2561.method_43471((String)descID).method_10852((class_2561)patternLabel);
        }
        return class_2561.method_43471((String)(descID + ".empty"));
    }

    public void method_7888(class_1799 pStack, class_1937 pLevel, class_1297 pEntity, int pSlotId, boolean pIsSelected) {
        if (NBTHelper.getBoolean(pStack, TAG_NEEDS_PURCHASE)) {
            NBTHelper.remove(pStack, TAG_NEEDS_PURCHASE);
        }
        if (NBTHelper.hasString(pStack, TAG_OP_ID) && !NBTHelper.hasCompound(pStack, TAG_PATTERN) && pEntity.method_5682() != null) {
            class_2960 opID = class_2960.method_12829((String)NBTHelper.getString(pStack, TAG_OP_ID));
            if (opID == null) {
                NBTHelper.remove(pStack, TAG_OP_ID);
                return;
            }
            class_5321 patternKey = class_5321.method_29179((class_5321)IXplatAbstractions.INSTANCE.getActionRegistry().method_30517(), (class_2960)opID);
            HexPattern pat = PatternRegistryManifest.getCanonicalStrokesPerWorld((class_5321<ActionRegistryEntry>)patternKey, pEntity.method_5682().method_30002());
            NBTHelper.put(pStack, TAG_PATTERN, (class_2520)pat.serializeToNBT());
        }
    }

    public void method_7851(class_1799 pStack, @Nullable class_1937 pLevel, List<class_2561> pTooltipComponents, class_1836 pIsAdvanced) {
        if (NBTHelper.getBoolean(pStack, TAG_NEEDS_PURCHASE)) {
            class_5250 needsPurchase = class_2561.method_43471((String)"hexcasting.tooltip.scroll.needs_purchase");
            pTooltipComponents.add((class_2561)needsPurchase.method_27692(class_124.field_1080));
        } else if (NBTHelper.hasString(pStack, TAG_OP_ID) && !NBTHelper.hasCompound(pStack, TAG_PATTERN)) {
            class_5250 notLoaded = class_2561.method_43471((String)"hexcasting.tooltip.scroll.pattern_not_loaded");
            pTooltipComponents.add((class_2561)notLoaded.method_27692(class_124.field_1080));
        }
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        class_2487 compound = NBTHelper.getCompound(stack, TAG_PATTERN);
        if (compound != null && !NBTHelper.getBoolean(stack, TAG_NEEDS_PURCHASE)) {
            HexPattern pattern = HexPattern.fromNBT(compound);
            return Optional.of(new PatternTooltip(pattern, NBTHelper.hasString(stack, TAG_OP_ID) ? PatternTooltipComponent.ANCIENT_BG : PatternTooltipComponent.PRISTINE_BG));
        }
        return Optional.empty();
    }
}

